<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://mycompany.com/mynamespace">
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="XOutFname" select="'c:\temp\test2.txt'"/>
  <xsl:param name="OutFileHandle" select="'0'"/>
  <xsl:param name="Filename" select="''"/>
  <!--##############  PARAMETER  ####################-->
  <!--##############  VARIABLES  ####################-->
  <!--##############  BEGIN Namspace cfg   ####################-->
  <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.1 $" versionscope="ALL_FILES" backup="true" backupdir="_repair_bu"/>
  <cfg:Description lang="DE">Repair - 3: Einfügen von SPANNING_TREE und ETHERNET falls nicht vorhanden</cfg:Description>
  <cfg:Description lang="EN">Repair - 3: Inserting of SPANNING_TREE and ETHERNET if missing</cfg:Description>
  <cfg:Texts>
  </cfg:Texts>
  <!--##############  END Namspace cfg   ####################-->
  <!--##############  MAIN Template for any ROOT ####################-->
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <!-- we do not copy attributes anymore (exception panelEncoding). Thus we force the creation of new rpsDisplayNames, which have been wrong in some RPS-versions  -->
  <!-- copy all nodes-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()">
    </xsl:apply-templates>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>
  <!-- Compare versions strings of form 'major.minor.sub' by script -->
  <msxsl:script language="javascript" implements-prefix="user">
   function IsVersionGreaterOrEqual(left,right)
   {
      // version strings of the form aa.bb.cc can be compared
      // aa bb cc may only contain 2 digits
      var versionLeft = 0;
      var versionRight = 0;
      var tokenLeft = left.split(".");
      versionLeft = Number(tokenLeft[0]) * 10000;
      versionLeft += Number(tokenLeft[1]) * 100;
      versionLeft += Number(tokenLeft[2]);
      var tokenRight = right.split(".");
      versionRight = Number(tokenRight[0]) * 10000;
      versionRight += Number(tokenRight[1]) * 100;
      versionRight += Number(tokenRight[2]);
      return versionLeft >= versionRight;
   }
   function IsHW_C(value)
   {
     if(value == "FPA5000-C" || value == "FPA5000_RK-C" || value == "FPA1200_EN-C")
     {
       return true;
     }
     return false;
   }
  </msxsl:script>
  <!-- -->
  <xsl:template match="NODE">
	<xsl:param name="SchemaVersion" select="string(/CONFIG_NETWORK/HEADER/dataVersion)"/>
    <xsl:element name="{name()}">
		<xsl:for-each select="*">
			<xsl:apply-templates select="."/>
			<xsl:if test="name() = 'usePanelNetworkingOverIP' and ../SPANNING_TREE = false() and user:IsVersionGreaterOrEqual($SchemaVersion, '2.8.0')">
			  <xsl:call-template name="InsertSPANNING_TREE"/>
			</xsl:if>
		</xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="NET_INTERFACES">
    <xsl:element name="{name()}">
		<xsl:for-each select="*">
			<xsl:apply-templates select="."/>
		</xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="ONBOARD">
    <xsl:element name="{name()}">
		<xsl:for-each select="*">
			<xsl:apply-templates select="."/>
			<xsl:if test="count(CANBUS) = 2">
				<xsl:if test="name() = 'CANBUS' and ./port = '2' and user:IsVersionGreaterOrEqual(string(/CONFIG_NETWORK/HEADER/dataVersion), '2.8.0')">
				  <xsl:call-template name="AddCANBUS">
					<xsl:with-param name="PortNbr">3</xsl:with-param>
				  </xsl:call-template>
				</xsl:if>
			</xsl:if>
			<xsl:if test="name() = 'CANBUS' and ./port = '3' and ../ETHERNET = false() and user:IsVersionGreaterOrEqual(string(/CONFIG_NETWORK/HEADER/dataVersion), '2.8.0')">
			  <xsl:call-template name="AddETHERNET">
				<xsl:with-param name="PortNbr">1</xsl:with-param>
			  </xsl:call-template>
			  <xsl:if test="user:IsHW_C(string(ancestor::NODE/nodeType)) = true()">
				<xsl:call-template name="AddETHERNET">
				  <xsl:with-param name="PortNbr">2</xsl:with-param>
				</xsl:call-template>
			  </xsl:if>
			</xsl:if>
		</xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template name="InsertSPANNING_TREE">
	<xsl:element name ="SPANNING_TREE">
		<xsl:element name="redundancyMode">OFF</xsl:element>
		<xsl:element name="STP_BridgePriority">32768</xsl:element>
		<xsl:element name="STP_HelloTime">2</xsl:element>
		<xsl:element name="STP_MaxAge">20</xsl:element>
		<xsl:element name="STP_ForwardDelay">15</xsl:element>
	</xsl:element>
  </xsl:template>
  <xsl:template name="AddETHERNET">
    <xsl:param name="PortNbr"/>
    <xsl:element name="ETHERNET">
      <xsl:element name="port">
        <xsl:value-of select="$PortNbr"/>
      </xsl:element>
      <xsl:element name="siType">MP_SI_NETWORK_LINE</xsl:element>
      <xsl:element name="enabled">
        <xsl:choose>
          <xsl:when test="$PortNbr = '1' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[3]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:when test="$PortNbr = '2' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[4]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '1' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '2' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>ST_NO</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="ETHERNET">
    <xsl:choose>
      <xsl:when test="user:IsHW_C(string(ancestor::NODE/nodeType)) = false() and port = '2'">
    </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name()}">
          <xsl:apply-templates select="*"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- -->
  <xsl:template name="AddCANBUS">
    <xsl:param name="PortNbr"/>
    <xsl:element name="CANBUS">
      <xsl:element name="port">
        <xsl:value-of select="$PortNbr"/>
      </xsl:element>
      <xsl:element name="siType">MP_SI_CANBUS</xsl:element>
      <xsl:element name="enabled">
        <xsl:choose>
          <xsl:when test="$PortNbr = '2' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[1]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:when test="$PortNbr = '3' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[2]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '2' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '3' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>ST_YES</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
    <xsl:template name="CreateEthernetInterface">
    <xsl:param name="InterfaceNumber"/>
    <xsl:element name="NET_INTERFACE">
      <xsl:element name="type">
        <xsl:text>ETHERNET</xsl:text>
      </xsl:element>
      <xsl:element name="interfaceNbr">
        <xsl:value-of select="$InterfaceNumber"/>
      </xsl:element>
      <xsl:element name="connectedToNetlineNbr">0</xsl:element>
      <!-- new in 2.8.2 isUsed -->
      <xsl:if test="user:IsVersionGreaterOrEqual(string(/CONFIG_NETWORK/HEADER/dataVersion),'2.8.2')">
        <xsl:element name="isUsed">ST_NO</xsl:element>
      </xsl:if>
      <xsl:element name="ETHERNET_PARAM">
        <xsl:element name="lineType">
          <xsl:text>CONNECTED_TO_LINK</xsl:text>
        </xsl:element>
        <xsl:element name="speedAndDuplex">
          <xsl:text>Auto</xsl:text>
        </xsl:element>
        <xsl:element name="flowControl">
          <xsl:text>Disabled</xsl:text>
        </xsl:element>
        <xsl:if test="user:IsVersionGreaterOrEqual(string(/CONFIG_NETWORK/HEADER/dataVersion),'2.8.2')">
          <xsl:element name="STP_PathCost">200000</xsl:element>
          <xsl:element name="STP_PortPriority">128</xsl:element>
          <xsl:element name="RSTP_LinkType">AUTO</xsl:element>
        </xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="NET_INTERFACE">
	<xsl:param name="SchemaVersion" select="string(/CONFIG_NETWORK/HEADER/dataVersion)"/>
	<xsl:element name="NET_INTERFACE">
		<xsl:apply-templates select="*"/>
	</xsl:element>
	<xsl:if test="./type = 'CAN' and ./interfaceNbr = '2'and count(../NET_INTERFACE)='2' and user:IsVersionGreaterOrEqual($SchemaVersion, '2.8.0')">
	  <xsl:call-template name="CreateEthernetInterface"> <xsl:with-param name="InterfaceNumber">1</xsl:with-param>
	  </xsl:call-template>
	  <xsl:if test="user:IsHW_C(string(ancestor::NODE/nodeType)) = true()">
		  <xsl:call-template name="CreateEthernetInterface"> <xsl:with-param name="InterfaceNumber">2</xsl:with-param>
		  </xsl:call-template>
	  </xsl:if>
	</xsl:if>
	<xsl:if test="./type = 'CAN' and ./interfaceNbr = '2'and count(../NET_INTERFACE)='3' and user:IsVersionGreaterOrEqual($SchemaVersion, '2.8.0') and following-sibling::NET_INTERFACE/type = 'ETHERNET' and following-sibling::NET_INTERFACE/interfaceNbr = '2'">
	   <!-- somehow the ethernet-interface with number 2 exists but the one with the number 1 is missing -->
	  <xsl:if test="user:IsHW_C(string(ancestor::NODE/nodeType)) = true()">
		  <xsl:call-template name="CreateEthernetInterface"> <xsl:with-param name="InterfaceNumber">1</xsl:with-param>
		  </xsl:call-template>
	  </xsl:if>
	</xsl:if>
  </xsl:template>
  <!-- -->
  </xsl:stylesheet>
